<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}

$msg = false;

if(isset($_POST["email"])){
    $email = isset($_POST["email"])?$_POST["email"]:"";
    $passwd = isset($_POST["passwd"])?$_POST["passwd"]:"";
    $passwd2 = isset($_POST["passwd2"])?$_POST["passwd2"]:"";
    $agreement = isset($_POST["agreement"])?$_POST["agreement"]:"";
    if($email == false || !validateEmail($email)){
        $msg = "邮箱格式错误";
    }elseif($passwd == false || strlen($passwd) < 6){
        $msg = "密码长度太短";
    }elseif($passwd !== $passwd2){
        $msg = "两次输入的密码不匹配";
    }elseif($agreement == false){
        $msg = "未同意《EarCMS分发系统使用协议》";
    }else{
        $user = new User();
        if($user->isExists($email)){
            $msg = "账号已存在或者禁止注册";
        }elseif(!$user->add($email, $passwd)){
            $msg = "系统错误";
        }else{
            $user->login($email, $passwd);
            header("Location: ".EAR_PATH."index.php/apps");
            exit;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="cn" class="light-style customizer-hide" dir="ltr" data-theme="theme-semi-dark" data-template="vertical-menu-template-semi-dark">

  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>注册 | <?php echo esc_html(EAR_NAME);?></title>
    <link rel="icon" type="image/x-icon" href="/favicon.ico" />
    <link rel="stylesheet" href="https://unpkg.com/boxicons@latest/css/boxicons.min.css">
    <link rel="stylesheet" href="<?php echo EAR_PATH;?>static/index/css/light.css?v=4.1" />
    <link rel="stylesheet" href="<?php echo EAR_PATH;?>static/index/css/plugins.css?v=7.5" />
  </head>

  <body>
    <div class="authentication-wrapper authentication-cover">
      <div class="authentication-inner row m-0">
        <div class="d-none d-lg-flex col-lg-7 col-xl-8 align-items-center p-5">
          <div class="w-100 d-flex justify-content-center">
            <img src="<?php echo EAR_PATH;?>static/index/image/slider24.png" class="img-fluid">
          </div>
        </div>
        <div class="d-flex col-12 col-lg-5 col-xl-4 align-items-center authentication-bg p-sm-5 p-4">
          <div class="w-px-400 mx-auto">
            <h4 class="mb-2">Welcome to <?php echo esc_html(EAR_NAME);?>!</h4>
            <?php if($msg){?>
            <p class="mb-4" style="color:#f44336;">注册失败：<?php echo esc_html($msg);?></p>
            <?php }else{ ?>
            <p class="mb-4">注册新账号</p>
            <?php } ?>
            <form id="reg_form" class="mb-3" action="" method="POST">

              <div class="mb-3">
                <label for="email" class="form-label">邮箱</label>
                <input type="email" class="form-control notnull" id="email" name="email" title="邮箱" placeholder="输入您的邮箱地址" autofocus>
              </div>

              <div class="form-password-toggle mb-3">
                <div class="d-flex justify-content-between">
                  <label class="form-label" for="passwd">设置密码</label>
                </div>
                <div class="input-group input-group-merge">
                  <input type="password" id="passwd" class="form-control notnull" name="passwd" title="密码" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" />
                  <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                </div>
              </div>
              
              <div class="form-password-toggle mb-3">
                <div class="d-flex justify-content-between">
                  <label class="form-label" for="passwd">确认密码</label>
                </div>
                <div class="input-group input-group-merge">
                  <input type="password" id="passwd" class="form-control notnull" name="passwd2" title="密码" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" />
                  <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                </div>
              </div>
              <div class="mb-3">
                <div class="form-check">
                  <input class="form-check-input" type="checkbox" name="agreement" value="1" id="agreement">
                  <label class="form-check-label" for="agreement">我已阅读 <a target="_blank" href="<?php echo EAR_PATH?>index.php/agreement">《EarCMS分发系统使用协议》</a></label>
                </div>
              </div>
              <button class="captcha_submit btn btn-primary d-grid w-100" type="submit">注册</button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </body>

</html>

