<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
if(!earis_login("admin")){
    header("Location: ".EAR_PATH.EAR_SCRIPT."/login");
    exit;
}

$msg = "";
$edit = (isset($_GET["edit"]) && in_array($_GET["edit"], array("detail", "template", "update")))?$_GET["edit"]:"detail";
if(in_array($edit, array("template", "update"))){
    echo html_message("版本限制", '<center>对不起，该版本未开通此功能，若您有该功能需求请联系<a href="https://www.earcms.com/" target="_blank">contact@earcms.com</a>获取。</center>');
    exit;
}

$appObj = new App();
$uuid = isset($_GET["uuid"])?trim($_GET["uuid"]):false;
$err = "";
$app = $appObj->getAPP($uuid);
if($app == false){
    die("Error: APP not found");
}
if(isset($_POST["type"]) && $_POST["type"] == "detail"){
    $shorturlObj = new ShortURL();
    $shorturl = isset($_POST["shorturl"])?trim($_POST["shorturl"]):"";
    $displayname = isset($_POST["displayname"])?trim($_POST["displayname"]):"";
    $version = isset($_POST["version"])?trim($_POST["version"]):"";
    if($shorturl == false){
        $msg = '<div class="alert alert-warning" role="alert" style="margin:2em 0 0 0;">下载链接禁止未空</div>';
    }elseif($shorturl != $uuid && !is_alphanum_str($shorturl)){
        $msg = '<div class="alert alert-warning" role="alert" style="margin:2em 0 0 0;">该下载链接无法使用</div>';
    }elseif(@$app["shorturl"] != $shorturl && $shorturlObj->get($shorturl)){
        $msg = '<div class="alert alert-warning" role="alert" style="margin:2em 0 0 0;">该下载链接无法使用</div>';
    }elseif(@$app["shorturl"] != $shorturl && !$shorturlObj->unset(@$app["shorturl"], $uuid)){
        $msg = '<div class="alert alert-warning" role="alert" style="margin:2em 0 0 0;">更新下载链接失败</div>';
    }elseif(@$app["shorturl"] != $shorturl && !$shorturlObj->set($shorturl, $uuid)){
        $msg = '<div class="alert alert-warning" role="alert" style="margin:2em 0 0 0;">更新下载链接失败</div>';
    }elseif(@$app["shorturl"] != $shorturl && !$appObj->update($uuid, "shorturl", $shorturl)){
        $msg = '<div class="alert alert-warning" role="alert" style="margin:2em 0 0 0;">更新下载链接失败</div>';
    }elseif($displayname == false){
        $msg = '<div class="alert alert-warning" role="alert" style="margin:2em 0 0 0;">应用名称禁止未空</div>';
    }elseif($version == false){
        $msg = '<div class="alert alert-warning" role="alert" style="margin:2em 0 0 0;">版本号禁止未空</div>';
    }elseif(@$app["displayname"] != $displayname && !$appObj->update($uuid, "displayname", $displayname)){
        $msg = '<div class="alert alert-warning" role="alert" style="margin:2em 0 0 0;">更新应用名称失败</div>';
    }elseif(@$app["version"] != $version && !$appObj->update($uuid, "version", $version)){
        $msg = '<div class="alert alert-warning" role="alert" style="margin:2em 0 0 0;">更新应用版本失败</div>';
    }else{
        $app = $appObj->getAPP($uuid);
        $msg = '<div class="alert alert-success" role="alert" style="margin:2em 0 0 0;">更新成功</div>';
    }
}

$title = @$app["displayname"]." | ".EAR_NAME;
require_once("header.inc.php");
?>

<p class="rs-p-wp-fix"></p>
<div class="main-content">
  <section class="iq-fancy-box-section">
    <div class="container" style="max-width:50em;">
      <div class="text-center">
        <img style="margin: 1em 0 4em 0;width:6em;" src="<?php echo esc_html($app["icon"]);?>" class="rounded" alt="avatar">
      </div>

      <nav class="nav nav-pills flex-column flex-sm-row">
        <a class="flex-sm-fill text-sm-center nav-link <?php echo ($edit=="detail")?"active":"";?>" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/app?uuid=<?php echo esc_html($uuid);?>&edit=detail">应用详情</a>
        <a class="flex-sm-fill text-sm-center nav-link <?php echo ($edit=="template")?"active":"";?>" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/app?uuid=<?php echo esc_html($uuid);?>&edit=template">下载页模板</a>
        <a class="flex-sm-fill text-sm-center nav-link <?php echo ($edit=="update")?"active":"";?>" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/app?uuid=<?php echo esc_html($uuid);?>&edit=update">更新应用</a>
      </nav>
      
      <?php echo $msg?$msg:"";?>

      <form method="POST" action="" style="margin: 3em 0;<?php echo ($edit!="detail")?"display:none;":"";?>">
        <div class="form-group row">
          <label for="inputShortURL" class="col-sm-2 col-form-label">下载地址</label>
          <div class="input-group col-sm-10">
            <div class="input-group-prepend">
              <div class="input-group-text"><?php echo (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]".EAR_PATH."app.php/";?></div>
            </div>
            <input type="text" name="shorturl" class="form-control" id="inputShortURL" value="<?php echo esc_html(@$app["shorturl"]?$app["shorturl"]:$uuid);?>" placeholder="数字或英文字符">
          </div>
        </div>
        <div class="form-group row">
          <label for="inputDisplayName" class="col-sm-2 col-form-label">应用名称</label>
          <div class="col-sm-10">
            <input type="text" name="displayname" class="form-control" value="<?php echo esc_html(@$app["displayname"]);?>" id="inputDisplayName">
            <small class="form-text text-muted">本项内容更改后仅显示于下载页面，无法改变安装包内的名称</small>
          </div>
        </div>
        <div class="form-group row">
          <label for="inputVersion" class="col-sm-2 col-form-label">版本</label>
          <div class="col-sm-10">
            <input type="text" class="form-control" name="version" value="<?php echo esc_html(@$app["version"]);?>" id="inputVersion">
            <small class="form-text text-muted">本项内容更改后仅显示于下载页面，无法改变安装包内的版本</small>
          </div>
        </div>
        <div class="form-group row">
          <label for="inputPackage" class="col-sm-2 col-form-label">包名</label>
          <div class="col-sm-10">
            <input type="text" readonly class="form-control" name="package" value="<?php echo esc_html(@$app["bid"]);?>" id="inputPackage">
          </div>
        </div>
        <div class="form-group row">
          <label for="inputSize" class="col-sm-2 col-form-label">体积</label>
          <div class="col-sm-10">
            <input type="text" readonly class="form-control" name="szie" value="<?php echo esc_html(human_filesize(@$app["size"]));?>" id="inputSize">
          </div>
        </div>
        <div class="form-group row">
          <label for="inputTime" class="col-sm-2 col-form-label">添加时间</label>
          <div class="col-sm-10">
            <input type="text" readonly class="form-control" name="package" value="<?php echo esc_html(date("Y-m-d H:i:s", @$app["addtime"]));?>" id="inputTime">
          </div>
        </div>
        <div class="form-group row">
          <div class="col-sm-10">
            <button type="submit" name="type" value="<?php echo esc_html($edit);?>" class="btn btn-primary">保存</button>
          </div>
        </div>
      </form>

    </div>
  </section>
</div>

<?php require_once("bottom.inc.php");?>
