<?php
require_once("init.php");

if(EAR_INMAINTENANCE){
    echo html_message("维护通知", EAR_MAINTENANCE);
    exit;
}

$path = explode('/', isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '');
$appid = (isset($path[1]) && is_safe_str($path[1]))? $path[1] : "";
$appObj = new App();
$suObj = new ShortURL();
$usrObj = new User();

$uuid = $appid;
$app = $appObj->getAPP($appid);
if($app == false && $suObj->get($appid)){
    $uuid = $suObj->get($appid);
    $app = $appObj->getAPP($uuid);
}
if($app == false){
    header("HTTP/1.1 404 Not Found");
    echo html_message("404", '<center>应用不存在。</center>');
    exit;
}
if(@$app["lock"] == true){
    header("HTTP/1.1 404 Not Found");
    echo html_message("404", '<center>应用被禁止。</center>');
    exit;
}

$email = isset($app["email"])?$app["email"]:false;
$user = $usrObj->getUser($email);
$times2down = isset($user["times2down"])?$user["times2down"]:0;
$ext = pathinfo(@$app["filename"], PATHINFO_EXTENSION);
?>
<!DOCTYPE html>
<html lang="zh-cn">

  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=0">

    <title><?php echo esc_html(@$app['displayname']?$app['displayname']:"应用下载");?> | <?php echo esc_html(EAR_NAME);?></title>
    <link href="<?php echo esc_html(EAR_PATH);?>static/app/download.css" rel="stylesheet">
    <link href="<?php echo esc_html(EAR_PATH);?>static/guide/swiper-3.3.1.min.css" rel="stylesheet">
    <link href="<?php echo esc_html(EAR_PATH);?>static/guide/ab.css" rel="stylesheet">
    <style type="text/css">
      .wechat_tip,
      .wechat_tip>i {
        position: absolute;
        right: 10px
      }

      .wechat_tip {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        background: #3ab2a7;
        color: #fff;
        font-size: 14px;
        font-weight: 500;
        width: 135px;
        height: 60px;
        border-radius: 10px;
        top: 15px
      }

      .wechat_tip>i {
        top: -10px;
        width: 0;
        height: 0;
        border-left: 6px solid transparent;
        border-right: 6px solid transparent;
        border-bottom: 12px solid #3ab2a7
      }

      .mask img {
        max-width: 100%;
        height: auto
      }

    </style>
    <script src="<?php echo esc_html(EAR_PATH);?>static/guide/zepto.min.js" type="text/javascript"></script>
    <script src="<?php echo esc_html(EAR_PATH);?>static/guide/swiper.jquery.min.js" type="text/javascript"></script>
    <script type="text/javascript">
      function mobile_provision() {
        document.getElementById('actions').innerHTML = '<p>正在安装，请按 Home 键在桌面查看</p><button onclick="location.href=\'<?php echo esc_html(EAR_PATH."download.php/{$appid}/app.mobileprovision"); ?>\'">立即信任</button>';
      }

      function install_app(_link) {
        if (!/android/.test(navigator.userAgent.toLowerCase())) {
          document.getElementById('actions').innerHTML = '<button style="min-width:43px;width:43px;padding:12px 0;border-top-color:transparent;border-left-color:transparent" class="loading">&nbsp;</button>';
          setTimeout("mobile_provision()", 6000);
        }
        location.href = _link;
      }

      function install_ing(_link) {
        location.href = _link;
        $(".text-bar")[0].innerHTML = "安装中";
        $(".change").show();
        $(".text-bar").attr("disabled", "true");
        $(".top-bar").css("width", "0.1%");
        timer = setTimeout(function() {
          $(".top-bar").css("width", "0.1%").animate({
            width: "20%"
          }, 1e3, function() {
            $("#mq1").hide();
            $(".device").show();
            var mySwiper = new Swiper(".swiper-container1", {
              nextButton: ".next_btn",
              autoplay: 3e3,
              autoplayStopOnLast: true
            });
            $(".top-bar").css("width", "20%").animate({
              width: "100%"
            }, 15e3, function() {
              $(".text-bar")[0].innerHTML = "立即信任";
              $(".text-bar").removeAttr("disabled");
              $(".text-bar").attr("href", "<?php echo EAR_PATH; ?>static/app/app.mobileprovision");
            });
          });
        }, 1e3);
      }

    </script>
  </head>

  <body>
    <?php if(strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger')){ ?>
    <div class="wechat_tip_content">
      <div class="wechat_tip"><i class="triangle-up"></i>请点击右上角<br>在<?php echo strpos($_SERVER['HTTP_USER_AGENT'], 'Android') ? '浏览器' : 'Safari'; ?>中打开</div>
    </div>
    <?php }else{ ?>
    <span class="pattern left"><img src="<?php echo EAR_PATH; ?>static/app/left.png"></span>
    <span class="pattern right"><img src="<?php echo EAR_PATH; ?>static/app/right.png"></span>
    <?php } ?>
    <div class="out-container">
      <div class="main">
        <header>
          <div class="table-container">
            <div class="cell-container">
              <div class="app-brief">
                <div class="icon-container wrapper">
                  <i class="icon-icon_path bg-path"></i>
                  <span class="icon"><img src="<?php echo esc_html($app["icon"]); ?>" onerror="this.src='<?php echo EAR_PATH; ?>static/app/<?php echo esc_html($ext); ?>.png'"></span>
                  <span class="qrcode"><img src="<?php echo EAR_PATH; ?>index.php/qrcode?str=<?php echo esc_html(urlencode(currenturl()));; ?>"></span>
                </div>
                <h1 class="name wrapper"><span class="icon-warp"><i class="icon-<?php echo ($ext=="ipa")?"apple":"android"; ?>"></i><?php echo $app['displayname']; ?></span></h1>
                <p class="scan-tips">扫描二维码下载<br />或用手机浏览器输入这个网址：<span class="text-black"><?php echo esc_html(currenturl()); ?></span></p>
                <div class="release-info">
                  <p><?php echo esc_html($app['bsvs']); ?>（Build <?php echo esc_html($app['bvs']); ?>）- <?php echo esc_html(human_filesize($app['size'])); ?></p>
                  <p>更新于：<?php echo esc_html(date("Y 年 m 月 d 日", $app['addtime'])); ?></p>
                </div>
                <?php if(is_mobile()){ ?>
                <div id="actions" class="actions">
                  <?php if(strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger')){ ?>
                  <button type="button">不支持在微信内下载安装</button>
                  <?php }else{ ?>
                    <?php if($times2down > 0){?>
                  <button onclick="install_app('<?php echo esc_html(EAR_PATH."download.php/{$appid}"); ?>')">下载安装</button>
                     <?php }else{ ?>
                     <button>开发者点数不足</button>
                     <?php } ?>
                  <?php } ?>
                </div>
                <?php } ?>
              </div>
            </div>
          </div>
        </header>
        <div class="footer"><?php echo $_SERVER['HTTP_HOST']; ?> 是应用内测平台，请自行甄别应用风险！如有问题可通过邮件反馈。<a class="one-key-report" href="mailto:<?php echo EAR_MAIL; ?>">联系我们</a></div>
      </div>
    </div>
  </body>

</html>

