<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
if (extension_loaded("mysql") && !((ini_bool("sql.safe_mode") || ini_bool("mysql.allow_local_infile")) && extension_loaded("pdo_mysql"))) {
    class MySQLDriver {
	    public $extension = "MySQL";
	    public $server_info;
	    public $affected_rows;
	    public $errno;
	    public $error;
	    public $_link;
	    public $_result;
	    
	    /** Connect to server
		* @param string
		* @param string
		* @param string
		* @return bool
		*/
		public function connect($server, $username, $password) {
			if (ini_bool("mysql.allow_local_infile")) {
				$this->error = lang('Disable %s or enable %s or %s extensions.', "'mysql.allow_local_infile'", "MySQLi", "PDO_MySQL");
				return false;
			}
			$this->_link = @mysql_connect(
				($server != "" ? $server : ini_get("mysql.default_host")),
				("$server$username" != "" ? $username : ini_get("mysql.default_user")),
				("$server$username$password" != "" ? $password : ini_get("mysql.default_password")),
				true,
				131072 // CLIENT_MULTI_RESULTS for CALL
			);
			if ($this->_link) {
				$this->server_info = mysql_get_server_info($this->_link);
			} else {
				$this->error = mysql_error();
			}
			return (bool) $this->_link;
		}

		/** Sets the client character set
		* @param string
		* @return bool
		*/
		public function set_charset($charset) {
			if (function_exists('mysql_set_charset')) {
				if (mysql_set_charset($charset, $this->_link)) {
					return true;
				}
				// the client library may not support utf8mb4
				mysql_set_charset('utf8', $this->_link);
			}
			return $this->query("SET NAMES $charset");
		}

		/** Quote string to use in SQL
		* @param string
		* @return string escaped string enclosed in '
		*/
		public function quote($string) {
			return "'" . mysql_real_escape_string($string, $this->_link) . "'";
		}

		/** Select database
		* @param string
		* @return bool
		*/
		public function select_db($database) {
			return mysql_select_db($database, $this->_link);
		}

		/** Send query
		* @param string
		* @param bool
		* @return mixed bool or MySQLDriverResult
		*/
		public function query($query, $unbuffered = false) {
			$result = @($unbuffered ? mysql_unbuffered_query($query, $this->_link) : mysql_query($query, $this->_link)); // @ - mute mysql.trace_mode
			$this->error = "";
			if (!$result) {
				$this->errno = mysql_errno($this->_link);
				$this->error = mysql_error($this->_link);
				return false;
			}
			if ($result === true) {
				$this->affected_rows = mysql_affected_rows($this->_link);
				$this->info = mysql_info($this->_link);
				return true;
			}
			return new MySQLDriverResult($result);
		}

		/** Send query with more resultsets
		* @param string
		* @return bool
		*/
		public function multi_query($query) {
			return $this->_result = $this->query($query);
		}

		/** Get current resultset
		* @return MySQLDriverResult
		*/
		public function store_result() {
			return $this->_result;
		}

		/** Fetch next resultset
		* @return bool
		*/
		public function next_result() {
			// MySQL extension doesn't support multiple results
			return false;
		}

		/** Get single field from result
		* @param string
		* @param int
		* @return string
		*/
		public function result($query, $field = 0) {
			$result = $this->query($query);
			if (!$result || !$result->num_rows) {
				return false;
			}
			return mysql_result($result->_result, 0, $field);
		}
    }
    
    class MySQLDriverResult {
		public $num_rows;
		public $_result;
		public $_offset = 0;

		/** Constructor
		* @param resource
		*/
		public function __construct($result) {
			$this->_result = $result;
			$this->num_rows = mysql_num_rows($result);
		}

		/** Fetch next row as associative array
		* @return array
		*/
		public function fetch_assoc() {
			return mysql_fetch_assoc($this->_result);
		}

		/** Fetch next row as numbered array
		* @return array
		*/
		public function fetch_row() {
			return mysql_fetch_row($this->_result);
		}

		/** Fetch next field
		* @return object properties: name, type, orgtable, orgname, charsetnr
		*/
		public function fetch_field() {
			$return = mysql_fetch_field($this->_result, $this->_offset++); // offset required under certain conditions
			$return->orgtable = $return->table;
			$return->orgname = $return->name;
			$return->charsetnr = ($return->blob ? 63 : 0);
			return $return;
		}

		/** Free result set
		*/
		public function __destruct() {
			mysql_free_result($this->_result);
		}
	}
}
