<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
class App{
    public $dir;
    public $uploadname = 'appfile';
    
    public function __construct(){
        $this->dir = EAR_DATA.DS."apps";
        $this->init();
    }
    
    public function init(){
        if(!file_exists($this->dir)){
            mkdir($this->dir, 0777, true);
        }
        if(!file_exists($this->dir.DS."index.php")){
            file_put_contents($this->dir.DS."index.php", "");
        }
    }
    
    public function getFilepath($uuid){
        if(!is_safe_str($uuid)){
            return false;
        }
        $files = glob($this->dir.DS."*_{$uuid}_*."."php");
        if($files == false){
            return false;
        }else{
            return $files[0];
        }
    }
    
    public function update($uuid, $key, $value){
        if(!is_safe_str($uuid)){
            return false;
        }
        $app = $this->getApp($uuid);
        if($app == false){
            return false;
        }
        $app[$key] = $value;
        $file = $this->getFilepath($uuid);
        $str = EarData::encode($app);
        return file_put_contents($file, $str);
    }
    
    public function getAPP($uuid){
        if(!is_safe_str($uuid)){
            return false;
        }
        $file = $this->getFilepath($uuid);
        if(!file_exists($file)){
            return false;
        }
        $str = file_get_contents($file);
        return EarData::decode($str);
    }
    
    public function getAPPFile($uuid){
        if(!is_safe_str($uuid)){
            return false;
        }
        $app = $this->getAPP($uuid);
        $file = $this->getFilepath($uuid);
        $dir = substr($file, 0, -4);
        $ext = pathinfo(@$app["filename"], PATHINFO_EXTENSION);
        $appfile = realpath($dir.DS."app.".$ext);
        if($app == false || $appfile == false || !file_exists($appfile))
            return false;
        return $appfile;
    }
    
    public function delete($uuid){
        if(!is_safe_str($uuid)){
            return false;
        }
        $file = $this->getFilepath($uuid);
        $dir = substr($file, 0, -4);
        if(file_exists($file)){
            unlink($file);
        }
        if(is_dir($dir)){
            deleteDirectory($dir);
        }
        return (file_exists($file) || file_exists($dir))?false:true;
    }
    
    public function getApps($email="", $sort=0, $offset=0, $length=100){
        $apps = array();
        if($email == false){
            $files = glob($this->dir.DS."*_*.php");
        }else{
            $files = glob($this->dir.DS."*_".md5($email).".php");
        }
        if($sort == 1){
            $files = array_reverse($files);
        }
        foreach(array_slice($files, $offset, $length) as $file){
            $str = file_get_contents($file);
            $apps[$file] = EarData::decode($str);
        }
        return $apps;
    }
    
    public function add($email, $file, $filename, $icon, $displayname, $version, $packagename="", $mnvs="", $bid="", $bsvs="", $bvs=""){
        $md5 = md5($email);
        $ext = pathinfo($file, PATHINFO_EXTENSION);
        if(!in_array($ext, array("apk", "ipa"))){
            throw new Exception("Invalid filename");
        }
        if ($icon != false && !preg_match("/^data:image\/\w+;base64,[a-zA-Z0-9\/\r\n+]*={0,2}$/i",$icon)) {
            throw new Exception('Invalid icon data.');
        }
        $uuid = uuid();
        $dir = time()."_".$uuid."_".$md5;
        $save_dir = $this->dir.DS.$dir;
        $save_info = $save_dir.".php";
        $save_app = $save_dir.DS."app.".$ext;
        $appinfo = array(
            "uuid"  => $uuid,
            "dir"   => $dir,
            "email"     => $email,
            "filename"  => $filename,
            "size"      => filesize($file),
            "icon"      => $icon,
            "displayname"   => $displayname,
            "version"   => $version,
            "packagename"   => $packagename,
            "mnvs"   => $mnvs,
            "bid"   => $bid,
            "bsvs"   => $bsvs,
            "bvs"   => $bvs,
            "times2down" => 0,
            "lock" => false,
            "addtime"   => time(),
        );
        try{
            if(!mkdir($save_dir, 0777, true)){
                throw new Exception("Create APP dir failed");
            }
            $str = EarData::encode($appinfo);
            if(!file_put_contents($save_info, $str)){
                throw new Exception("Save APP info failed");
            }
            if(!rename($file, $save_app)){
                throw new Exception("Save APP failed");
            }
        }catch (Exception $e) {
            if(file_exists($save_dir)){
                deleteDirectory($save_dir);
            }
            if(file_exists($save_info)){
                unlink($save_info);
            }
            throw new Exception($e->getMessage());
        }
        return $uuid;
    }
}
