<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}

function deleteDirectory($dirPath) {
    if (is_dir($dirPath)) {
        $objects = scandir($dirPath);
        foreach ($objects as $object) {
            if ($object != "." && $object !="..") {
                if (filetype($dirPath . DIRECTORY_SEPARATOR . $object) == "dir") {
                    deleteDirectory($dirPath . DIRECTORY_SEPARATOR . $object);
                } else {
                    unlink($dirPath . DIRECTORY_SEPARATOR . $object);
                }
            }
        }
    reset($objects);
    rmdir($dirPath);
    }
}

function human_filesize($bytes, $dec = 2): string {

    $size   = array('B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
    $factor = floor((strlen($bytes) - 1) / 3);
    if ($factor == 0) $dec = 0;


    return sprintf("%.{$dec}f %s", $bytes / (1024 ** $factor), $size[$factor]);

}

function file_upload_max_size() {
  static $max_size = -1;

  if ($max_size < 0) {
    // Start with post_max_size.
    $post_max_size = parse_size(ini_get('post_max_size'));
    if ($post_max_size > 0) {
      $max_size = $post_max_size;
    }

    // If upload_max_size is less, then reduce. Except if upload_max_size is
    // zero, which indicates no limit.
    $upload_max = parse_size(ini_get('upload_max_filesize'));
    if ($upload_max > 0 && $upload_max < $max_size) {
      $max_size = $upload_max;
    }
  }
  return $max_size;
}

function parse_size($size) {
  $unit = preg_replace('/[^bkmgtpezy]/i', '', $size); // Remove the non-unit characters from the size.
  $size = preg_replace('/[^0-9\.]/', '', $size); // Remove the non-numeric characters from the size.
  if ($unit) {
    // Find the position of the unit in the ordered string which is the power of magnitude to multiply a kilobyte by.
    return round($size * pow(1024, stripos('bkmgtpezy', $unit[0])));
  }
  else {
    return round($size);
  }
}

function currenturl(){
    return (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
}

function earlaunch($c, $m, $a){
    global $ear_config;
    try {
        if(!is_alphanum_str($c) || !is_alphanum_str($m)){
            throw new Exception('Invalid controller or module.');
        }
        if($a != false){
            $mpath = EAR_ROOT.DS.'source'.DS.$c.DS.$m.'.class.php';
        }else{
            $mpath = EAR_ROOT.DS.'source'.DS.$c.DS.$m.'.php';
        }
        if(!file_exists($mpath)){
            throw new Exception('Module not exists.');
        }
        
        define('CONTROLLER', $c);
        define('MODULE', $m);
        
        require_once($mpath);
        
        if($a != false){
            $cls_name = 'EarMod'.ucfirst($m);
            if(!class_exists($cls_name) || !is_alphanum_str($a) || !method_exists($cls_name, $a)){
                throw new Exception('Invalid action.');
            }
            define('ACTION', $a);
            $obj = new $cls_name;
            $obj->$a();
        }
    } catch (Exception $e) {
        if(EAR_DEBUG){
            die('Caught error exception: '.$e->getMessage());
        }else{
            die('Access denied');
        }
    }
}

function earis_login($type="user"){
    if(@$_SESSION[$type] != false){
        return true;
    }else{
        return false;
    }
}

function is_safe_str($str) {
    if (preg_match('/^[_\.\-0-9a-zA-Z]+$/i', $str)) {
        return true;
    } else {
        return false;
    }
}

function is_alphanum_str($str) {
    if (preg_match('/^[0-9a-zA-Z]+$/i', $str)) {
        return true;
    } else {
        return false;
    }
}

function is_valid_url($url){
	if(strpos($url, '//') !== false || strpos($url, '\\\\') !== false)
	    return false;
	return true;
}

function get_ip(){
	$ip = $_SERVER['REMOTE_ADDR'];
	if(isset($_SERVER['X-Forwarded-For']) && filter_var($_SERVER['X-Forwarded-For'], FILTER_VALIDATE_IP)){
		$ip = $_SERVER['X-Forwarded-For'];
	}elseif(isset($_SERVER['X-Real-IP']) && filter_var($_SERVER['X-Real-IP'], FILTER_VALIDATE_IP)){
		$ip = $_SERVER['X-Real-IP'];
	}
	return $ip;
}

function is_session_started() {
    if (php_sapi_name() !== 'cli') {
        if (version_compare(phpversion(), '5.4.0', '>=')) {
            return session_status() === PHP_SESSION_ACTIVE ? TRUE : FALSE;
        } else {
            return session_id() === '' ? FALSE : TRUE;
        }
    }
    return FALSE;
}

function is_mobile() {
	if ( empty( $_SERVER['HTTP_USER_AGENT'] ) ) {
		$is_mobile = false;
	} elseif ( strpos( $_SERVER['HTTP_USER_AGENT'], 'Mobile' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Android' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Silk/' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Kindle' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'BlackBerry' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Opera Mini' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'MicroMessenger') !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Opera Mobi' ) !== false ) {
			$is_mobile = true;
	} else {
		$is_mobile = false;
	}

	return $is_mobile;
}

function is_json($string) {
    $string = trim($string);
    json_decode($string, true);
    return (json_last_error() == JSON_ERROR_NONE);
}

function esc_html($string) {
    if (is_array($string)) {
        foreach ($string as $key => $val) {
            $string [$key] = esc_html($val);
        }
    } else {
        $string = htmlspecialchars($string);
    }
    return $string;
}

function get_salt($length = 8) {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $salt = '';
    for ($i = 0; $i < $length; $i ++) {
        $salt .= $chars [mt_rand(0, strlen($chars) - 1)];
    }
    return $salt;
}

function validateEmail($address, $patternselect = null){
    if (null === $patternselect) {
        $patternselect = "php";
    }
    //Don't allow strings as callables, see SECURITY.md and CVE-2021-3603
    if (is_callable($patternselect) && !is_string($patternselect)) {
        return call_user_func($patternselect, $address);
    }
    //Reject line breaks in addresses; it's valid RFC5322, but not RFC5321
    if (strpos($address, "\n") !== false || strpos($address, "\r") !== false) {
        return false;
    }
    switch ($patternselect) {
        case 'pcre': //Kept for BC
        case 'pcre8':
            /*
             * A more complex and more permissive version of the RFC5322 regex on which FILTER_VALIDATE_EMAIL
             * is based.
             * In addition to the addresses allowed by filter_var, also permits:
             *  * dotless domains: `a@b`
             *  * comments: `1234 @ local(blah) .machine .example`
             *  * quoted elements: `'"test blah"@example.org'`
             *  * numeric TLDs: `a@b.123`
             *  * unbracketed IPv4 literals: `a@192.168.0.1`
             *  * IPv6 literals: 'first.last@[IPv6:a1::]'
             * Not all of these will necessarily work for sending!
             *
             * @see       http://squiloople.com/2009/12/20/email-address-validation/
             * @copyright 2009-2010 Michael Rushton
             * Feel free to use and redistribute this code. But please keep this copyright notice.
             */
            return (bool) preg_match(
                '/^(?!(?>(?1)"?(?>\\\[ -~]|[^"])"?(?1)){255,})(?!(?>(?1)"?(?>\\\[ -~]|[^"])"?(?1)){65,}@)' .
                '((?>(?>(?>((?>(?>(?>\x0D\x0A)?[\t ])+|(?>[\t ]*\x0D\x0A)?[\t ]+)?)(\((?>(?2)' .
                '(?>[\x01-\x08\x0B\x0C\x0E-\'*-\[\]-\x7F]|\\\[\x00-\x7F]|(?3)))*(?2)\)))+(?2))|(?2))?)' .
                '([!#-\'*+\/-9=?^-~-]+|"(?>(?2)(?>[\x01-\x08\x0B\x0C\x0E-!#-\[\]-\x7F]|\\\[\x00-\x7F]))*' .
                '(?2)")(?>(?1)\.(?1)(?4))*(?1)@(?!(?1)[a-z0-9-]{64,})(?1)(?>([a-z0-9](?>[a-z0-9-]*[a-z0-9])?)' .
                '(?>(?1)\.(?!(?1)[a-z0-9-]{64,})(?1)(?5)){0,126}|\[(?:(?>IPv6:(?>([a-f0-9]{1,4})(?>:(?6)){7}' .
                '|(?!(?:.*[a-f0-9][:\]]){8,})((?6)(?>:(?6)){0,6})?::(?7)?))|(?>(?>IPv6:(?>(?6)(?>:(?6)){5}:' .
                '|(?!(?:.*[a-f0-9]:){6,})(?8)?::(?>((?6)(?>:(?6)){0,4}):)?))?(25[0-5]|2[0-4][0-9]|1[0-9]{2}' .
                '|[1-9]?[0-9])(?>\.(?9)){3}))\])(?1)$/isD',
                $address
            );
        case 'html5':
            /*
             * This is the pattern used in the HTML5 spec for validation of 'email' type form input elements.
             *
             * @see https://html.spec.whatwg.org/#e-mail-state-(type=email)
             */
            return (bool) preg_match(
                '/^[a-zA-Z0-9.!#$%&\'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}' .
                '[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/sD',
                $address
            );
        case 'php':
        default:
            return filter_var($address, FILTER_VALIDATE_EMAIL) !== false;
    }
}

function uuid() {
    return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        // 32 bits for "time_low"
        mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),

        // 16 bits for "time_mid"
        mt_rand( 0, 0xffff ),

        // 16 bits for "time_hi_and_version",
        // four most significant bits holds version number 4
        mt_rand( 0, 0x0fff ) | 0x4000,

        // 16 bits, 8 bits for "clk_seq_hi_res",
        // 8 bits for "clk_seq_low",
        // two most significant bits holds zero and one for variant DCE1.1
        mt_rand( 0, 0x3fff ) | 0x8000,

        // 48 bits for "node"
        mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )
    );
}

function debug_mode() {
    if (defined('EAR_DEBUG') && EAR_DEBUG) {
        error_reporting(E_ALL);
    } else {
        error_reporting(0);
    }
}

function html_message($title, $msg, $code = '') {
	return '<html><head><meta http-equiv="Content-Type" content="text/html; charset=' . (defined('EAR_CHARSET')?EAR_CHARSET:'utf-8') . '" /><title>&#69;&#97;&#114;&#67;&#77;&#83; 提示</title></head><body bgcolor="#FFFFFF"><table cellpadding="0" cellspacing="0" border="0" width="850" align="center" height="85%"><tr align="center" valign="middle"><td><table cellpadding="20" cellspacing="0" border="0" width="80%" align="center" style="font-family: Verdana, Tahoma; color: #666666; font-size: 12px"><tr><td valign="middle" align="center" bgcolor="#EBEBEB"><b style="font-size: 16px">' . $title . '</b><br/><br/><p style="text-align:left;">' . $msg . '</p><br/><br/></td></tr></table></td></tr></table>' . $code . '</body></html>';;
}
