<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
function earcms_autoload($classname) {
	$filename = EAR_ROOT.DS."source".DS.'system'.DS.'libs'.DS.strtolower($classname).'.class.php';
	if (is_readable ($filename)) {
		require_once($filename);
	}
}
if (version_compare ( PHP_VERSION, '5.1.2', '>=' )) {
	// SPL autoloading was introduced in PHP 5.1.2
	if (version_compare ( PHP_VERSION, '5.3.0', '>=' )) {
		spl_autoload_register ( 'earcms_autoload', true, true );
	} else {
		spl_autoload_register ( 'earcms_autoload' );
	}
} else {
	/**
	 * Fall back to traditional autoload for old PHP versions
	 * 
	 * @param string $classname
	 *        	The name of the class to load
	 */
	function __autoload($classname) {
		earcms_autoload ( $classname );
	}
}
