<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
?>
<!doctype html>
<html lang="cn">

  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo isset($title)?esc_html($title):esc_html(EAR_NAME." | ".EAR_DESCRIPTION);?></title>
    <link rel="shortcut icon" href="/favicon.ico" />
    <link rel="stylesheet" href="<?php echo EAR_PATH;?>static/index/css/index.min.css">
    <link rel="stylesheet" href="<?php echo EAR_PATH;?>static/index/font/iconfont.css?v=1.0">
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css">
    <script src="//cdn.jsdelivr.net/npm/showdown@2.1.0/dist/showdown.min.js" type="text/javascript"></script>
    <style>
    .hidden {
        display: none !important;
    }
    </style>
    <script src="<?php echo EAR_PATH;?>static/index/js/index.min.js" type="text/javascript"></script>
  <body>
    <div id="loading">
      <div id="loading-center">
        <div class="load-img">
          <img src="<?php echo EAR_PATH;?>static/index/image/loader.gif" alt="loader">
        </div>
      </div>
    </div>
    <header id="main-header" class="header-main header2" style="background:#FFF;">
      <div class="container">
        <div class="row">
          <div class="col-sm-12">
            <nav class="navbar navbar-expand-lg navbar-light">
              <a class="navbar-brand" href="<?php echo EAR_PATH;?>" style="color:#007bff;font-weight:bold;"><?php echo esc_html(EAR_NAME);?></a>
              <div class="collapse navbar-collapse">
              </div>
              <div class="sub-main">
                <ul>
                  <li class="menu-item"><a href="<?php echo EAR_PATH;?>index.php/price">服务价格</a></li>
                  <?php if(earis_login()){?>
                  <li class="menu-item"><a href="<?php echo EAR_PATH;?>index.php/pack">应用封装</a></li>
                  <li class="menu-item"><a href="<?php echo EAR_PATH;?>index.php/apps">应用管理</a></li>
                  <li class="menu-item"><a href="<?php echo EAR_PATH;?>index.php/user">个人资料</a></li>
                  <li class="menu-item"><a href="<?php echo EAR_PATH;?>index.php/logout">退出</a></li>
                  <?php }else{ ?>
                  <li class="menu-item"><a href="https://www.earcms.com/">系统更新</a></li>
                  <li class="d-inline"><a href="<?php echo EAR_PATH;?>index.php/login" class="login iq-button iq-btn-outline iq-btn-round">登 录</a></li>
                  <li class="d-inline"><a href="<?php echo EAR_PATH;?>index.php/register" class="signup iq-button default iq-btn-round">注册</a></li>
                  <?php } ?>
                </ul>
              </div>
            </nav>
          </div>
        </div>
      </div>
    </header>

