<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}

if(!earis_login()){
    header("Location: ".EAR_PATH."index.php/login");
    exit;
}

$sort = isset($_GET["sort"])?intval($_GET["sort"]):1;
$offset = isset($_GET["offset"])?intval($_GET["offset"]):0;
$length = isset($_GET["length"])?intval($_GET["length"]):10;
$appObj = new App();
$apps = $appObj->getApps($_SESSION["user"]["email"], $sort, $offset, $length);

$usrObj = new User();
$user = $usrObj->getUser($_SESSION["user"]["email"]);

$title = "应用列表 | ".EAR_NAME;
require_once("header.inc.php");
?>
<p class="rs-p-wp-fix"></p>
<div class="main-content">
  <section class="iq-fancy-box-section">
    <img src="<?php echo EAR_PATH;?>static/index/image/shape1.png" class="img-fluid shape-left" alt="QLOUD">
    <div class="container" style="max-width:60em;">
      <div class="alert alert-info" role="alert" style="margin:0 0 2em 0;font-size:80%;">注意： 我们依法全力打击和防范互联网电信诈骗犯罪，严禁上传金融借贷、区块链虚拟币、博彩、以及任何含有网络电信诈骗功能的App，一经发现立即删除，并上报网络安全监管部门。</div>

      <form id="appform" action="<?php echo EAR_PATH;?>index.php/uploadapp" method="POST" enctype="multipart/form-data">
        <nav class="nav nav-pills flex-column flex-sm-row" style="text-align:center;">
          <label style="cursor:pointer;" class="flex-sm-fill text-sm-center nav-link active" href="#" for="appfile">
            <i class="bi-cloud-upload-fill" style="font-size: 2rem;"></i><br />上传应用
            <input style="display:none;" id="appfile" accept=".ipa,.apk" type="file" name="appfile" />
          </label>
          <input style="display:none;" id="appdetail" type="hidden" name="appdetail" />
          <a class="flex-sm-fill text-sm-center nav-link" href="<?php echo EAR_PATH;?>index.php/price"><i class="bi-cart-check-fill" style="font-size: 2rem;"></i><br />购买额度</a>
          <div class="flex-sm-fill text-sm-right" style="padding-top:0.5em;">
            <small>剩余签名次数</small>
            <br><span style="font-size:2em;"><?php echo intval(isset($user["times2sign"])?$user["times2sign"]:0)?></span>
          </div>
          <div class="flex-sm-fill text-sm-right" style="padding-top:0.5em;">
            <small>剩余分发次数</small>
            <br><span style="font-size:2em;"><?php echo intval(isset($user["times2down"])?$user["times2down"]:0)?></span>
          </div>
          <div class="flex-sm-fill text-sm-right" style="padding-top:0.5em;">
            <small>剩余封装次数</small>
            <br><span style="font-size:2em;"><?php echo intval(isset($user["times2pack"])?$user["times2pack"]:0)?></span>
          </div>
        </nav>
      </form>

      <?php if($apps == false){ ?>
      <div class="alert alert-light" role="alert" style="margin:2em 0;text-align:center;">无内容</div>
      <?php }else{ ?>
      <table class="table table-hover" style="margin: 2em 0;">
        <thead>
          <tr>
            <th scope="col">#</th>
            <th scope="col">APP名称</th>
            <th scope="col">版本</th>
            <th scope="col">大小</th>
            <th scope="col">下载数</th>
            <th scope="col">添加时间</th>
            <th scope="col">操作</th>
          </tr>
        </thead>
        <tbody>
          <?php 
        $id = $offset;
        foreach($apps as $path => $app){
            $ext = pathinfo(@$app["filename"], PATHINFO_EXTENSION);
            $uuid = explode("_", basename($path))[1];
            $label = ($ext=="apk")?"android2":(($ext=="ipa")?"apple":"file-earmark-fill");
            echo '<tr>
            <td>'.(++$id).'</td>
            <td class="align-middle" style="text-align:left;">
                <img style="width:1.5em;height:1.5em;border-radius:0.5em;" src="'.esc_html(@$app["icon"]).'" />
                <a style="color:#5e7290;" href="'.esc_html(EAR_PATH."index.php/app?uuid=".$uuid).'">'.esc_html($app["displayname"]).'</a>
                <i class="bi-'.esc_html($label).'" style="font-size: 1rem;"></i>
            </td>
            <td class="align-middle">'.esc_html(@$app["version"]).'</td>
            <td class="align-middle">'.esc_html(human_filesize(@$app["size"])).'</td>
            <td class="align-middle">'.intval(@$app["times2down"]).'</td>
            <td class="align-middle">'.esc_html(date("Y-m-d H:i:s", @$app["addtime"])).'</td>
            <td class="align-middle">
              <a href="'.esc_html(EAR_PATH."app.php/".(@$app["shorturl"]?$app["shorturl"]:$uuid)).'" target="_blank" class="btn btn-light btn-sm" title="浏览">浏览</a>
              <a href="'.esc_html(EAR_PATH."index.php/app?uuid=".$uuid).'" class="btn btn-light btn-sm" title="编辑">编辑</a>
              <a href="'.esc_html(EAR_PATH."index.php/deleteapp?uuid=".$uuid).'" onclick="javascript:return confirm(\'确定要删除第 '.$id.' 行数据？\');" class="btn btn-danger btn-sm" title="删除">删除</a>
            </td>
          </tr>';
        }
        ?>
        </tbody>
      </table>

      <nav aria-label="Page navigation">
        <ul class="pagination">
          <li class="page-item <?php echo ($offset)?"":"disabled";?>"><a class="page-link" href="<?php echo ($offset)?EAR_PATH."index.php/apps?offset=".($offset-$length)."&length={$length}":"#";?>">上一页</a></li>
          <li class="page-item <?php echo (count($apps)<$length)?"disabled":"";?>"><a class="page-link" href="<?php echo ($apps)?EAR_PATH."index.php/apps?offset=".($offset+$length)."&length={$length}":"#";?>">下一页</a></li>
        </ul>
      </nav>

      <?php }?>
    </div>
  </section>
</div>
<div id="appinfo" class="hidden" style="display:flex;align-items:center;justify-content: center;position:fixed;top:0;left:0;z-index:999;width:100%;height:100%;background-color:#f2f2f4;">
  <div style="text-align:center;">
    <img class="logo hidden" style="width:5em;height:5em;background:#FFF;border-radius:1em;" src="/static/index/image/applogo.png" />
    <h4 class="hidden" style="line-height:2em;"><span class="name">APPNAME</span></h4>
    <p class="hidden" style="margin-bottom:2em;font-size:80%;"><span class="packagename">Packagename</span></p>
    <p class="hidden" style="margin-bottom:2em;">版本：<span class="version">1.0.0</span> | 体积：<span class="size">1.5MB</span></p>
    <img style="width:3em;height:3em;border-radius:3em;" src="/static/index/image/loader.gif" />
    <p style="margin-top:1em;font-size:80%;">文件处理中，请勿关闭页面</p>
  </div>
</div>
<script src="<?php echo EAR_PATH;?>static/index/js/app-info-parser.min.js"></script>
<script>
  $(document).ready(function() {
    $('#appfile').on('change', function() {
      try {
        var file = document.getElementById('appfile').files[0];
        var sizelimit = <?php echo EAR_MAXSIZE; ?> ;
        var sliceLimit = <?php echo floor(file_upload_max_size() * 0.9); ?> ;

        if (file.size > sizelimit) {
          alert("错误：文件体积不能大于" + humanFileSize(sizelimit, true));
        }

        $("#appinfo").removeClass("hidden");

        var parser = new window.AppInfoParser(file);
        parser.parse().then(result => {
          console.log('app info: ', result);
          var displayname = file.name;
          var packname = "null";
          var version = "null";
          var icon = "null";
          var execname = "null";
          var mnvs = "null";
          var bid = "null";
          var bsvs = "null";
          var bvs = "null";

          if (result.CFBundleDisplayName) {
            displayname = result.CFBundleDisplayName;
          } else if (result.CFBundleName) {
            displayname = result.CFBundleName;
          } else if (result.application.label[0]) {
            displayname = result.application.label[0];
          } else if (result.application.name) {
            displayname = result.application.name;
          }

          if (result.package) {
            packname = result.package;
          } else if (result.CFBundleIdentifier) {
            packname = result.CFBundleIdentifier;
          } else if (result.CFBundleName) {
            packname = result.CFBundleName;
          }

          if (result.versionName) {
            version = result.versionName;
          } else if (result.versionCode) {
            version = result.versionCode;
          } else if (result.CFBundleShortVersionString) {
            version = result.CFBundleShortVersionString;
          } else if (result.CFBundleVersion) {
            version = result.CFBundleVersion;
          }

          if (result.icon) {
            icon = result.icon;
          }

          if (result.CFBundleExecutable) {
            execname = result.CFBundleExecutable;
          } else if (result.application.name) {
            execname = result.application.name;
          }

          if (result.MinimumOSVersion) {
            mnvs = result.MinimumOSVersion;
          } else if (result.usesSdk.minSdkVersion) {
            mnvs = result.usesSdk.minSdkVersion;
          }

          if (result.CFBundleIdentifier) {
            bid = result.CFBundleIdentifier;
          } else if (result.package) {
            bid = result.package;
          }

          if (result.CFBundleShortVersionString) {
            bsvs = result.CFBundleShortVersionString;
          } else if (result.versionName) {
            bsvs = result.versionName;
          }

          if (result.CFBundleVersion) {
            bvs = result.CFBundleVersion;
          } else if (result.versionCode) {
            bvs = result.versionCode;
          }

          $("#appinfo .logo").attr("src", result.icon);
          $("#appinfo .name").text(displayname);
          $("#appinfo .packagename").text(packname);
          $("#appinfo .version").text(version);
          $("#appinfo .size").text(humanFileSize(file.size, true));

          $("#appdetail").val(JSON.stringify({
            displayname: displayname,
            packagename: packname,
            version: version,
            icon: icon,
            execname: execname,
            mnvs: mnvs,
            bid: bid,
            bsvs: bsvs,
            bvs: bvs,
          }));

          var session = makeFormSession(32);
          var start = -1;
          var end = start + sliceLimit;
          var form_data = null;
          var xhr = null;
          var retry = 0;
          var appurl = "";

          while (start < file.size && appurl == "") {
            if (retry > 3) {
              throw new Error("timeout");
            }
            form_data = new FormData();
            if (start == -1) {
              form_data.append("appdetail", $("#appdetail").val());
            } else {
              form_data.append("appfile", file.slice(start, end));
            }
            form_data.append("filename", file.name);
            form_data.append("session", session);
            form_data.append("start", start);
            form_data.append("size", file.size);
            console.log(start);
            $.ajax({
              url: $('#appform').attr("action"),
              method: 'POST',
              async: false,
              data: form_data,
              contentType: false,
              cache: false,
              processData: false,
              success: function(data) {
                console.log(data);
                if (data.toLowerCase().includes("success:")) {
                  appurl = data.toLowerCase().split("success:")[1];
                  console.log(appurl);
                } else if (!data.toLowerCase().includes("error")) {
                  retry = 0;
                  if (start == -1) {
                    start = 0;
                  } else {
                    start = end;
                  }
                  end = start + sliceLimit;
                } else {
                  retry++;
                }
              }
            }).fail(function() {
              retry++;
            });
          }
          if (appurl != "") {
            window.location = appurl;
            return;
          } else {
            throw new Error("error");
          }
        }).catch(err => {
          console.log('err: ', err);
          alert("上传失败：" + err);
        }).finally(() => {
          $('#appform').trigger("reset");
          $("#appinfo").addClass("hidden");
          console.log('app upload finish');
        });
      } catch (error) {
        alert("上传失败：" + error.message);
      }
      $('#appform').trigger("reset");
      console.log('app upload finish');
    });
  });

  function makeFormSession(length) {
    let result = '';
    const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    const charactersLength = characters.length;
    let counter = 0;
    while (counter < length) {
      result += characters.charAt(Math.floor(Math.random() * charactersLength));
      counter += 1;
    }
    return result;
  }

  function humanFileSize(bytes, si = false, dp = 1) {
    const thresh = si ? 1000 : 1024;

    if (Math.abs(bytes) < thresh) {
      return bytes + ' B';
    }

    const units = si ?
      ['kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'] :
      ['KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'];
    let u = -1;
    const r = 10 ** dp;

    do {
      bytes /= thresh;
      ++u;
    } while (Math.round(Math.abs(bytes) * r) / r >= thresh && u < units.length - 1);


    return bytes.toFixed(dp) + ' ' + units[u];
  }

</script>
<?php require_once("bottom.inc.php");?>

