<?php
require_once("init.php");

if(EAR_INMAINTENANCE){
    echo html_message("维护通知", EAR_MAINTENANCE);
    exit;
}

$path = explode('/', isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '');
$appid = (isset($path[1]) && is_safe_str($path[1]))? $path[1] : "";
$appObj = new App();
$suObj = new ShortURL();
$usrObj = new User();

$uuid = $appid;
$app = $appObj->getAPP($uuid);
if($app == false && $suObj->get($appid)){
    $uuid = $suObj->get($appid);
    $app = $appObj->getAPP($uuid);
}
$app_times2down = intval(@$app["times2down"]);

if($app == false){
    header("HTTP/1.1 404 Not Found");
    echo html_message("404", '<center>应用不存在。</center>');
    exit;
}
$email = isset($app["email"])?$app["email"]:false;
$user = $usrObj->getUser($email);
$user_times2down = isset($user["times2down"])?$user["times2down"]:0;
if($user_times2down <= 0){
    header("HTTP/1.1 404 Not Found");
    echo html_message("404", '<center>开发者点数不足。</center>');
    exit;
}

$ext = pathinfo(@$app["filename"], PATHINFO_EXTENSION);
$filename = ($app["bid"]?$app["bid"]:"app").".{$ext}";
$appfile = $appObj->getAPPFile($uuid);
if($appfile == false || !in_array($ext, array("apk", "ipa"))){
    header("HTTP/1.1 404 Not Found");
    echo html_message("404", '<center>应用不存在。</center>');
    exit;
}

$appObj->update($uuid, "times2down", $app_times2down+1);
$usrObj->update($email, "times2down", $user_times2down-1);


if($ext == "apk"){
    header('Content-Description: File Transfer');
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="'.urlencode(basename($filename)).'"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($appfile));
    readfile($appfile);
    exit;
}elseif($ext == "ipa"){
    header('location:itms-services://?action=download-manifest&url=https://' . $_SERVER['HTTP_HOST'] . EAR_PATH . "plist.php/{$appid}.plist");
    exit;
}
