/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexPointerBlock;
import hu.uw.pallergabor.dedexer.DexProtoIdsBlock;
import hu.uw.pallergabor.dedexer.DexStringIdsBlock;
import hu.uw.pallergabor.dedexer.DexTypeIdsBlock;
import java.io.IOException;

public class DexMethodIdsBlock
extends DexParser {
    private String[] methods;
    private String[] protos;
    private DexPointerBlock dexPointerBlock = null;
    private DexStringIdsBlock dexStringIdsBlock = null;
    private DexTypeIdsBlock dexTypeIdsBlock = null;
    private DexProtoIdsBlock dexProtoIdsBlock = null;

    @Override
    public void parse() throws IOException {
        int methodsSize = (int)this.dexPointerBlock.getMethodIdsSize();
        this.file.seek(this.dexPointerBlock.getMethodIdsOffset());
        this.methods = new String[methodsSize];
        this.protos = new String[methodsSize];
        int i = 0;
        while (i < methodsSize) {
            int classTypeIdx = this.read16Bit();
            int protoIdx = this.read16Bit();
            int nameStringIdx = (int)this.read32Bit();
            StringBuilder b = new StringBuilder();
            String clazzName = this.dexTypeIdsBlock.getClassName(classTypeIdx);
            b.append(clazzName);
            b.append('/');
            b.append(this.dexStringIdsBlock.getString(nameStringIdx));
            this.methods[i] = new String(b);
            b = new StringBuilder();
            b.append(this.dexStringIdsBlock.getString(nameStringIdx));
            b.append('(');
            b.append(this.dexProtoIdsBlock.getParameterValueTypes(protoIdx));
            b.append(')');
            b.append(this.dexProtoIdsBlock.getReturnValueType(protoIdx));
            this.protos[i] = new String(b);
            this.dump("method[" + i + "]: " + this.methods[i] + " (" + this.protos[i] + ")");
            ++i;
        }
    }

    public int getMethodsSize() {
        return (int)this.dexPointerBlock.getMethodIdsSize();
    }

    public String getMethod(int idx) {
        return this.methods[idx];
    }

    public String getProto(int idx) {
        return this.protos[idx];
    }

    public static String getMethodName(String fullMethodName) {
        int idx = fullMethodName.lastIndexOf(47);
        if (idx < 0) {
            return fullMethodName;
        }
        return fullMethodName.substring(idx + 1);
    }

    public static String combineMethodNameAndProto(String methodName, String proto) {
        String combined = proto;
        int pidx = methodName.indexOf(47);
        if (pidx >= 0) {
            combined = String.valueOf(methodName.substring(0, pidx + 1)) + proto;
        }
        return combined;
    }

    public static String getResultType(String proto) {
        int pos = proto.lastIndexOf(41);
        if (pos < 0) {
            return null;
        }
        return proto.substring(pos + 1);
    }

    public void setDexPointerBlock(DexPointerBlock dexPointerBlock) {
        this.dexPointerBlock = dexPointerBlock;
    }

    public void setDexStringIdsBlock(DexStringIdsBlock dexStringIdsBlock) {
        this.dexStringIdsBlock = dexStringIdsBlock;
    }

    public void setDexTypeIdsBlock(DexTypeIdsBlock dexTypeIdsBlock) {
        this.dexTypeIdsBlock = dexTypeIdsBlock;
    }

    public void setDexProtoIdsBlock(DexProtoIdsBlock dexProtoIdsBlock) {
        this.dexProtoIdsBlock = dexProtoIdsBlock;
    }
}

