/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.Annotation;
import hu.uw.pallergabor.dedexer.AnnotationHolder;
import hu.uw.pallergabor.dedexer.DexEncodedArrayParser;
import hu.uw.pallergabor.dedexer.DexFieldIdsBlock;
import hu.uw.pallergabor.dedexer.DexMethodIdsBlock;
import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import hu.uw.pallergabor.dedexer.DexStringIdsBlock;
import hu.uw.pallergabor.dedexer.DexTypeIdsBlock;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;

public class DexAnnotationParser
extends DexParser {
    public static final int VISIBILITY_BUILD = 0;
    public static final int VISIBILITY_RUNTIME = 1;
    public static final int VISIBILITY_SYSTEM = 2;
    private static String[] systemAnnotations = new String[]{"Ldalvik/annotation/Throws;", "Ldalvik/annotation/EnclosingClass;", "Ldalvik/annotation/InnerClass;", "Ldalvik/annotation/MemberClasses;", "Ldalvik/annotation/EnclosingMethod;"};
    private DexTypeIdsBlock dexTypeIdsBlock = null;
    private DexStringIdsBlock dexStringIdsBlock = null;
    private DexFieldIdsBlock dexFieldIdsBlock = null;
    private DexMethodIdsBlock dexMethodIdsBlock = null;
    private DexEncodedArrayParser arrayParser = null;
    private DexSignatureBlock dexSignatureBlock = null;
    private ArrayList<AnnotationHolder> fieldAnnotationHolders = new ArrayList();
    private ArrayList<AnnotationHolder> methodAnnotationHolders = new ArrayList();
    private ArrayList<AnnotationHolder> parameterAnnotationHolders = new ArrayList();
    private ArrayList<AnnotationHolder> classAnnotationHolders = new ArrayList();
    private HashMap<String, Integer> fieldMap = new HashMap();
    private HashMap<String, Integer> methodMap = new HashMap();
    private HashMap<String, Integer> parameterMap = new HashMap();

    public DexAnnotationParser() {
        this.arrayParser = new DexEncodedArrayParser();
    }

    @Override
    public void parse() throws IOException {
        long[] addresses;
        int methodIdx;
        AnnotationHolder h;
        long annotationOffset;
        int i;
        this.setDexOptimizationData(this.dexSignatureBlock.getDexOptimizationData());
        this.arrayParser.setRandomAccessFile(this.file);
        this.arrayParser.setDumpFile(this.dump);
        long classAnnotationOffset = this.readFileOffset();
        this.dump("class annotation offset: 0x" + Long.toHexString(classAnnotationOffset));
        long fieldAnnotationSize = this.read32Bit();
        this.dump("field annotation size: " + fieldAnnotationSize);
        long methodAnnotationSize = this.read32Bit();
        this.dump("method annotation size: " + methodAnnotationSize);
        long parameterAnnotationSize = this.read32Bit();
        this.dump("parameter annotation size: " + parameterAnnotationSize);
        if (fieldAnnotationSize != 0L) {
            i = 0;
            while ((long)i < fieldAnnotationSize) {
                int fieldIdx = (int)this.read32Bit();
                this.dump("field idx: " + fieldIdx);
                annotationOffset = this.readFileOffset();
                this.dump("annotation offset: 0x" + Long.toHexString(annotationOffset));
                h = new AnnotationHolder();
                h.asset = this.dexFieldIdsBlock.getFieldName(fieldIdx);
                h.offset = annotationOffset;
                this.fieldAnnotationHolders.add(h);
                this.fieldMap.put(h.asset, new Integer(i));
                ++i;
            }
        }
        if (methodAnnotationSize != 0L) {
            i = 0;
            while ((long)i < methodAnnotationSize) {
                methodIdx = (int)this.read32Bit();
                this.dump("method idx: " + methodIdx);
                annotationOffset = this.readFileOffset();
                this.dump("annotation offset: 0x" + Long.toHexString(annotationOffset));
                h = new AnnotationHolder();
                h.asset = DexMethodIdsBlock.getMethodName(this.dexMethodIdsBlock.getMethod(methodIdx));
                h.offset = annotationOffset;
                this.methodAnnotationHolders.add(h);
                this.methodMap.put(h.asset, new Integer(i));
                ++i;
            }
        }
        if (parameterAnnotationSize != 0L) {
            i = 0;
            while ((long)i < parameterAnnotationSize) {
                methodIdx = (int)this.read32Bit();
                this.dump("method idx: " + methodIdx);
                annotationOffset = this.readFileOffset();
                this.dump("annotation offset: 0x" + Long.toHexString(annotationOffset));
                h = new AnnotationHolder();
                h.asset = DexMethodIdsBlock.getMethodName(this.dexMethodIdsBlock.getMethod(methodIdx));
                h.offset = annotationOffset;
                this.parameterAnnotationHolders.add(h);
                this.parameterMap.put(h.asset, new Integer(i));
                ++i;
            }
        }
        i = 0;
        while (i < this.fieldAnnotationHolders.size()) {
            AnnotationHolder h2 = this.fieldAnnotationHolders.get(i);
            this.file.seek(h2.offset);
            int count = (int)this.read32Bit();
            addresses = new long[count];
            int n = 0;
            while (n < count) {
                addresses[n] = this.readFileOffset();
                this.dump("field annotation offset: 0x" + Long.toHexString(addresses[n]));
                ++n;
            }
            n = 0;
            while (n < count) {
                this.file.seek(addresses[n]);
                this.readAnnotation(h2, "fieldAnnotation for " + h2.asset + ", entry[" + n + "]");
                ++n;
            }
            ++i;
        }
        i = 0;
        while (i < this.methodAnnotationHolders.size()) {
            AnnotationHolder h3 = this.methodAnnotationHolders.get(i);
            this.file.seek(h3.offset);
            int count = (int)this.read32Bit();
            addresses = new long[count];
            int n = 0;
            while (n < count) {
                addresses[n] = this.readFileOffset();
                this.dump("method annotation offset: 0x" + Long.toHexString(addresses[n]));
                ++n;
            }
            n = 0;
            while (n < count) {
                this.file.seek(addresses[n]);
                this.readAnnotation(h3, "methodAnnotation for " + h3.asset + ", entry[" + n + "]");
                ++n;
            }
            ++i;
        }
        i = 0;
        while (i < this.parameterAnnotationHolders.size()) {
            AnnotationHolder h4 = this.parameterAnnotationHolders.get(i);
            this.file.seek(h4.offset);
            int count = (int)this.read32Bit();
            addresses = new long[count];
            int n = 0;
            while (n < count) {
                addresses[n] = this.readFileOffset();
                this.dump("parameter annotation offset: 0x" + Long.toHexString(addresses[n]));
                ++n;
            }
            n = 0;
            while (n < count) {
                this.file.seek(addresses[n]);
                int acount = (int)this.read32Bit();
                if (acount != 0) {
                    long[] annotationAddresses = new long[acount];
                    int k = 0;
                    while (k < acount) {
                        annotationAddresses[k] = this.readFileOffset();
                        this.dump("parameter annotation offset for parameter " + n + ": 0x" + Long.toHexString(addresses[n]));
                        ++k;
                    }
                    k = 0;
                    while (k < acount) {
                        this.file.seek(annotationAddresses[k]);
                        this.readAnnotation(h4, "parameterAnnotation for " + h4.asset + ", parameter[" + n + "], entry[" + k + "]");
                        Annotation a = h4.lastAnnotation();
                        a.parameterIndex = n;
                        ++k;
                    }
                }
                ++n;
            }
            ++i;
        }
        if (classAnnotationOffset != 0L) {
            this.file.seek(classAnnotationOffset);
            int count = (int)this.read32Bit();
            long[] entries = new long[count];
            int i2 = 0;
            while (i2 < count) {
                entries[i2] = this.readFileOffset();
                ++i2;
            }
            i2 = 0;
            while (i2 < count) {
                this.file.seek(entries[i2]);
                AnnotationHolder classAnnotationHolder = this.readAnnotation("classAnnotation");
                this.classAnnotationHolders.add(classAnnotationHolder);
                ++i2;
            }
        }
    }

    @Override
    public void setRandomAccessFile(RandomAccessFile file) {
        super.setRandomAccessFile(file);
        this.arrayParser.setRandomAccessFile(file);
    }

    @Override
    public void setDumpFile(PrintStream dump) {
        super.setDumpFile(dump);
        this.arrayParser.setDumpFile(dump);
    }

    public void setDexSignatureBlock(DexSignatureBlock dexSignatureBlock) {
        this.dexSignatureBlock = dexSignatureBlock;
    }

    public void setDexTypeIdsBlock(DexTypeIdsBlock dexTypeIdsBlock) {
        this.dexTypeIdsBlock = dexTypeIdsBlock;
        this.arrayParser.setDexTypeIdsBlock(dexTypeIdsBlock);
    }

    public void setDexStringIdsBlock(DexStringIdsBlock dexStringIdsBlock) {
        this.dexStringIdsBlock = dexStringIdsBlock;
        this.arrayParser.setDexStringIdsBlock(dexStringIdsBlock);
    }

    public void setDexFieldIdsBlock(DexFieldIdsBlock dexFieldIdsBlock) {
        this.dexFieldIdsBlock = dexFieldIdsBlock;
        this.arrayParser.setDexFieldIdsBlock(dexFieldIdsBlock);
    }

    public void setDexMethodIdsBlock(DexMethodIdsBlock dexMethodIdsBlock) {
        this.dexMethodIdsBlock = dexMethodIdsBlock;
        this.arrayParser.setDexMethodIdsBlock(dexMethodIdsBlock);
    }

    public int getBlockIndexFromAsset(AnnotationType type, String asset) {
        HashMap<String, Integer> map = this.getAnnotationMap(type);
        Integer i = map.get(asset);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public int getAnnotationBlocksSize(AnnotationType type) {
        ArrayList<AnnotationHolder> annotationList = this.getAnnotationList(type);
        return annotationList.size();
    }

    public int getAnnotationsSize(AnnotationType type, int idx) {
        ArrayList<AnnotationHolder> annotationList = this.getAnnotationList(type);
        if (idx >= annotationList.size()) {
            return 0;
        }
        AnnotationHolder h = annotationList.get(idx);
        return h.annotations.size();
    }

    public String getAnnotationAsset(AnnotationType type, int idx) {
        ArrayList<AnnotationHolder> annotationList = this.getAnnotationList(type);
        AnnotationHolder h = annotationList.get(idx);
        return h.asset;
    }

    public int getAnnotationVisibilityFlag(AnnotationType type, int idx, int aidx) {
        ArrayList<AnnotationHolder> annotationList = this.getAnnotationList(type);
        AnnotationHolder h = annotationList.get(idx);
        Annotation a = h.annotations.get(aidx);
        return a.visibility;
    }

    public String getAnnotationType(AnnotationType type, int idx, int aidx) {
        ArrayList<AnnotationHolder> annotationList = this.getAnnotationList(type);
        AnnotationHolder h = annotationList.get(idx);
        Annotation a = h.annotations.get(aidx);
        return a.type;
    }

    public int searchAnnotationType(AnnotationType type, int idx, String typeToSearch) {
        ArrayList<AnnotationHolder> annotationList = this.getAnnotationList(type);
        AnnotationHolder h = annotationList.get(idx);
        int i = 0;
        while (i < h.annotations.size()) {
            Annotation a = h.annotations.get(i);
            if (typeToSearch.equals(a.type)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getAnnotationElementsSize(AnnotationType type, int idx, int aidx) {
        ArrayList<AnnotationHolder> annotationList = this.getAnnotationList(type);
        AnnotationHolder h = annotationList.get(idx);
        Annotation a = h.annotations.get(aidx);
        return a.elementNames.size();
    }

    public String getAnnotationElementName(AnnotationType type, int idx, int aidx, int element) {
        ArrayList<AnnotationHolder> annotationList = this.getAnnotationList(type);
        AnnotationHolder h = annotationList.get(idx);
        Annotation a = h.annotations.get(aidx);
        return a.elementNames.get(element);
    }

    public Object getAnnotationElementValue(AnnotationType type, int idx, int aidx, int element) {
        ArrayList<AnnotationHolder> annotationList = this.getAnnotationList(type);
        AnnotationHolder h = annotationList.get(idx);
        Annotation a = h.annotations.get(aidx);
        return a.elementValues.get(element);
    }

    public int getAnnotationParameterIndex(AnnotationType type, int idx, int aidx) {
        ArrayList<AnnotationHolder> annotationList = this.getAnnotationList(type);
        AnnotationHolder h = annotationList.get(idx);
        Annotation a = h.annotations.get(aidx);
        return a.parameterIndex;
    }

    public static boolean isSystemAnnotation(String type) {
        int i = 0;
        while (i < systemAnnotations.length) {
            if (type.equals(systemAnnotations[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ArrayList<AnnotationHolder> getAnnotationList(AnnotationType type) {
        ArrayList<AnnotationHolder> list = null;
        switch (type) {
            case FIELD: {
                list = this.fieldAnnotationHolders;
                break;
            }
            case METHOD: {
                list = this.methodAnnotationHolders;
                break;
            }
            case PARAMETER: {
                list = this.parameterAnnotationHolders;
                break;
            }
            case CLASS: {
                list = this.classAnnotationHolders;
            }
        }
        return list;
    }

    private HashMap<String, Integer> getAnnotationMap(AnnotationType type) {
        HashMap<String, Integer> map = null;
        switch (type) {
            case FIELD: {
                map = this.fieldMap;
                break;
            }
            case METHOD: {
                map = this.methodMap;
                break;
            }
            case PARAMETER: {
                map = this.parameterMap;
            }
        }
        return map;
    }

    private AnnotationHolder readAnnotation(String tag) throws IOException {
        AnnotationHolder annotationHolder = new AnnotationHolder();
        return this.readAnnotation(annotationHolder, tag);
    }

    private AnnotationHolder readAnnotation(AnnotationHolder annotationHolder, String tag) throws IOException {
        annotationHolder.newAnnotation();
        int visibility = this.read8Bit();
        annotationHolder.setVisibility(visibility);
        this.dump(String.valueOf(tag) + ": visibility: " + this.visibilityString(visibility));
        return this.readEncodedAnnotation(annotationHolder, tag);
    }

    public AnnotationHolder readEncodedAnnotation(AnnotationHolder annotationHolder, String tag) throws IOException {
        String type = this.dexTypeIdsBlock.getType((int)this.readVLN());
        annotationHolder.setType(type);
        this.dump(String.valueOf(tag) + ": type: " + type);
        int annotationElements = (int)this.readVLN();
        int n = 0;
        while (n < annotationElements) {
            int elementNameIdx = (int)this.readVLN();
            String elementName = this.dexStringIdsBlock.getString(elementNameIdx);
            this.dump(String.valueOf(tag) + ": element[" + n + "], name: " + elementName);
            Object elementValue = this.arrayParser.readElement();
            this.dump(String.valueOf(tag) + ": element[" + n + "], value: " + elementValue);
            annotationHolder.addElement(elementName, elementValue);
            ++n;
        }
        return annotationHolder;
    }

    private String visibilityString(int visibilityFlag) {
        String visibilityString = null;
        switch (visibilityFlag) {
            case 0: {
                visibilityString = "VISIBILITY_BUILD";
                break;
            }
            case 1: {
                visibilityString = "VISIBILITY_RUNTIME";
                break;
            }
            case 2: {
                visibilityString = "VISIBILITY_SYSTEM";
                break;
            }
            default: {
                visibilityString = "Unknown visibility (0x" + Integer.toHexString(visibilityFlag) + ")";
            }
        }
        return visibilityString;
    }

    public static enum AnnotationType {
        FIELD,
        METHOD,
        PARAMETER,
        CLASS;

    }
}

